<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Administrativo | JFD Admin</title>
    <link rel="icon" type="image/png" href="../public/img/logo-jfd.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;600;800;900&family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: { sans: ['Roboto', 'sans-serif'], display: ['Barlow', 'sans-serif'] },
                    colors: {
                        brand: { black: '#050505', dark: '#121212', red: '#D90429', red_hover: '#EF233C', yellow: '#FFD60A', light: '#F8F9FA' }
                    }
                }
            }
        }
    </script>
    <style>
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #333; border-radius: 3px; }
        .dark ::-webkit-scrollbar-thumb { background: #D90429; }
        .font-display { font-family: 'Barlow', sans-serif; }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmDelete(id, name) {
    Swal.fire({
        title: '¿ELIMINAR ASESOR?',
        text: `Borrarás a ${name} definitivamente.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#D90429',
        confirmButtonText: 'SÍ, BORRAR'
    }).then((result) => {
        if (result.isConfirmed) {
            document.getElementById('form-delete-' + id).submit();
        }
    });
}
</script>
</head>
<body class="bg-brand-light dark:bg-brand-black text-gray-800 dark:text-gray-200 font-sans transition-colors duration-300">
    <div class="flex h-screen overflow-hidden">